 LST OFF
* TCP SOCKET DEMO FOR W5100/UTHERNET II
* BY D. FINNIGAN
* OCTOBER 2015
*
* UPDATED 09 JAN 2016
*
*
* SLOT 4 I/O ADDRESSES FOR THE W5100
*
WMODE EQU $C0C4
WADRH EQU $C0C5
WADRL EQU $C0C6
WDATA EQU $C0C7
*
*
* IMPORTANT LOCATIONS WITHIN THE W5100
*
MACADDR EQU $0009 ; MAC ADDRESS
SRCIP EQU $000F ; SOURCE IP ADDRESS
RMSR EQU $001A ; RECEIVE BUFFER SIZE
*
* SOCKET 0 LOCATIONS
*
S0MR EQU $0400 ; SOCKET 0 MODE REGISTER
S0CR EQU $0401 ; COMMAND REGISTER
S0IR EQU $0402 ; INTERRUPT REGISTER
S0SR EQU $0403 ; STATUS REGISTER
S0LOCALPORT EQU $0404 ; LOCAL PORT
S0FORADDR EQU $040C ; FOREIGN ADDRESS
S0FORPORT EQU $0410 ; FOREIGN PORT
S0MSS EQU $0412 ; MAXIMUM SEGMENT SIZE
S0PROTO EQU $0414 ; IP PROTOCOL
S0TOS EQU $0415 ; DS/ECN (FORMER TOS)
S0TTL EQU $0416 ; IP TIME TO LIVE
S0TXFSR EQU $0420 ; TX FREE SIZE REGISTER
S0TXRR EQU $0422 ; TX READ POINTER REGISTER
S0TXWR EQU $0424 ; TX WRITE POINTER REGISTER
S0RXRSR EQU $0426 ; RX RECEIVED SIZE REGISTER
S0RXRD EQU $0428 ; RX READ POINTER REGISTER
*
* SOCKET 0 PARAMETERS
*
RXBASE EQU $6000 ; SOCKET 0 RX BASE ADDR
RXMASK EQU $1FFF ; SOCKET 0 8 KB ADDRESS MASK
TXBASE EQU $4000 ; SOCKET 0 TX BASE ADDR
TXMASK EQU RXMASK ; SOCKET 0 TX MASK = RX MASK
*
*
* SOCKET COMMANDS
*
SCOPEN EQU $01 ; OPEN
SCLISTEN EQU $02 ; LISTEN
SCCONNECT EQU $04 ; CONNECT
SCDISCON EQU $08 ; DISCONNECT
SCCLOSE EQU $10 ; CLOSE
SCSEND EQU $20 ; SEND
SCSENDMAC EQU $21 ; SEND MAC
SCSENDKEEP EQU $22 ; SEND KEEP ALIVE
SCRECV EQU $40 ; RECV
*
* SOCKET STATUS
*
STCLOSED EQU $00 ; CLOSED
STINIT EQU $13 ; SOCK INIT
STLISTEN EQU $14 ; SOCK LISTEN
STESTABLISHED EQU $17 ; SOCK ESTABLISHED
STCLOSEWAIT EQU $1C ; SOCK CLOSE WAIT
STUDP EQU $22 ; UDP
STIPRAW EQU $32 ; IP RAW
STMACRAW EQU $42 ; MAC RAW
STPPOE EQU $5F ; PPOE
*
* MONITOR SUBROUTINES
*
KBD EQU $C000
KBDSTRB EQU $C010
COUT EQU $FDED
PRBYTE EQU $FDDA
PRNTAX EQU $F941
*
* ZERO-PAGE STORAGE
*
PTR EQU $06 ; 2 BYTES FOR APPLE BUFFER
GETSIZE EQU $08 ; 2 BYTES FOR RX_RSR
GETOFFSET EQU $0A ; 2 BYTES FOR OFFSET ADDR
GETSTARTADR EQU $0C ; 2 BYTES FOR PHYSICAL ADDR
*
*
* RESET AND CONFIGURE W5100
*
*
 LDA #$80 ; RESET
 STA WMODE
 LDA #3 ; CONFIGURE WITH AUTO-INC
 STA WMODE
*
* ASSIGN MAC ADDRESS
*
 LDA #>MACADDR
 STA WADRH
 LDA #<MACADDR
 STA WADRL
 LDX #0
:L LDA MAC,X
 STA WDATA ; USING AUTO-INC HERE
 INX
 CPX #6 ; COMPLETED?
 BNE :L
 JMP SETSRCADDR ; MOVE ON
*
MAC HEX 0008DC010203 ; MAC ADDRESS TO ASSIGN
*
*
* ASSIGN A SOURCE IP ADDRESS
*
SETSRCADDR
 LDA #<SRCIP
 STA WADRL
 LDX #0
:L LDA SRCADDR,X
 STA WDATA
 INX
 CPX #4
 BNE :L
 JMP SETBUFFERS
*
SRCADDR HEX C0A80205 ; 192.168.2.5
*
*
* CONFIGURE BUFFER SIZES
*
SETBUFFERS
 LDA #<RMSR
 STA WADRL
 LDA #3 ; 8 KB TO SOCKET 0
 STA WDATA ; SET RECEIVE BUFFER
 STA WDATA ; SET TRANSMIT BUFFER
*
* CONFIGURE SOCKET 0 FOR TCP
*
 LDA #>S0MR
 STA WADRH
 LDA #<S0MR
 STA WADRL
 LDA #1 ; TCP MODE
 STA WDATA
*
* SET LOCAL PORT NUMBER
*
 LDA #<S0LOCALPORT
 STA WADRL
 LDA #$C0 ; HIGH BYTE OF LOCAL PORT
 STA WDATA
 LDA #0 ; LOW BYTE
 STA WDATA
*
* SET FOREIGN ADDRESS
*
 LDA #<S0FORADDR
 STA WADRL
 LDX #0
:L2 LDA FADDR,X
 STA WDATA
 INX
 CPX #4
 BNE :L2
 JMP SETFORPORT
*
FADDR HEX C0A80201 ; 192.168.2.1
*
*
* SET FOREIGN PORT
*
SETFORPORT
 LDA #$4E ; HIGH BYTE OF FOREIGN PORT
 STA WDATA ; ADDRESS POINTER IS AT FOREIGN PORT
 LDA #$20 ; LOW BYTE OF PORT
 STA WDATA
*
* OPEN SOCKET
*
 LDA #<S0CR
 STA WADRL
 LDA #SCOPEN ; OPEN COMMAND
 STA WDATA
*
* CHECK STATUS REGISTER TO SEE IF OPEN COMMAND SUCCEEDED
*
 LDA #<S0SR
 STA WADRL
 LDA WDATA
 CMP #STINIT ; IS IT SOCK_INIT?
 BEQ OPENED ; YES, CONTINUE
 LDY #0
:L LDA :SOCKERR,Y
 BEQ :LDONE
 JSR COUT
 INY
 BNE :L
:LDONE BRK
:SOCKERR ASC "UTHERNET II: COULD NOT OPEN SOCKET!"
 HEX 8D00
*
* TCP SOCKET IS NOW WAITING FOR ITS NEXT COMMAND
*
OPENED
 LDA #<S0CR
 STA WADRL
 LDA #SCCONNECT ; CONNECT
 STA WDATA
*
* NOW WAIT FOR TCP TO CONNECT AND BECOME ESTABLISHED
*
CHECKTEST
 LDA #<S0SR
 STA WADRL
 LDA WDATA ; GET SOCKET STATUS
 BEQ ERRDONE ; 0 = SOCKET CLOSED, ERROR
 CMP #STESTABLISHED ; IS IT SOCK_ESTABLISHED?
 BNE CHECKTEST ; NEED MORE TIME TO ESTABLISH
*
* AT THIS POINT, SOCKET IS READY FOR DATA TRANSMISSION
*
 JMP CHECKRECV
*
ERRDONE
 LDY #0
:L LDA ERRMSG,Y
 BEQ :DONE
 JSR COUT
 INY
 BNE :L
:DONE BRK
*
ERRMSG ASC "SOCKET COULD NOT CONNECT - CHECK REMOTE HOST"
 HEX 8D00
*
*
* CHECK FOR ANY RECEIVED DATA
*
CHECKRECV
 BIT KBD ; KEY PRESS?
 BPL :NEXT
 LDA KBDSTRB
 JMP CLOSECONN ; CLOSE CONNECTION
:NEXT
 LDA #<S0RXRSR ; S0 RECEIVED SIZE REGISTER
 STA WADRL
 LDA WDATA ; HIGH BYTE OF RECEIVED SIZE
 ORA WDATA ; LOW BYTE
 BEQ NORECV ; NO DATA TO READ
 JMP RECV ; THERE IS DATA TO RECEIVE
*
NORECV
 NOP  ; MAKE A LITTLE DELAY...
 NOP
 JMP CHECKRECV ; AND CHECK AGAIN
*
* THERE IS DATA TO READ. COMPUTE THE PHYSICAL ADDRESS
*
RECV
 LDA #<S0RXRSR ; GET RECEIVED SIZE AGAIN
 STA WADRL
 LDA WDATA
 STA GETSIZE+1 ; HIGH BYTE
 LDA WDATA
 STA GETSIZE ; LOW BYTE
*
* CALCULATE OFFSET ADDRESS USING READ POINTER AND RX MASK
*
 LDA #<S0RXRD
 STA WADRL
 LDA WDATA ; HIGH BYTE
 AND #>RXMASK
 STA GETOFFSET+1
 LDA WDATA ; LOW BYTE
 AND #<RXMASK
 STA GETOFFSET
*
* CALCULATE PHYSICAL ADDRESS WITHIN W5100 RX BUFFER
*
 CLC
 LDA GETOFFSET
 ADC #<RXBASE
 STA GETSTARTADR
 LDA GETOFFSET+1
 ADC #>RXBASE
 STA GETSTARTADR+1
*
* SET BUFFER ADDRESS ON APPLE
*
 LDA #0 ; LOW BYTE OF BUFFER
 STA PTR
 LDA #$50 ; HIGH BYTE
 STA PTR+1
*
* CHECK IF THERE IS BUFFER WRAPAROUND
*
 CLC
 LDA GETOFFSET
 ADC GETSIZE
 STA ]RXWRAPCHECK
 LDA GETOFFSET+1
 ADC GETSIZE+1
 STA ]RXWRAPCHECK+1
*
* IS ]RXWRAPCHECK >= RXMASK?
*
 LDA ]RXWRAPCHECK
 CMP #<RXMASK
 LDA ]RXWRAPCHECK+1
 SBC #>RXMASK
 BCS RXWRAP ; THERE IS WRAPAROUND
 JMP RXNOWRAP
*
]RXWRAPCHECK DS 2
*
*
* IF THERE IS NO WRAPAROUND IN THE BUFFER, SIMPLY LOOP
* OVER ALL BYTES AND COPY TO A BUFFER ON THE APPLE
*
RXNOWRAP
*
* SET BUFFER ADDRESS ON W5100
*
 LDA GETSTARTADR+1 ; HIGH BYTE FIRST
 STA WADRH
 LDA GETSTARTADR
 STA WADRL
*
* BEGIN COPY
*
 LDY #0
 LDX GETSIZE+1
 BEQ :LAST ; LESS THAN 256 BYTES
:L LDA WDATA
 STA (PTR),Y

 JSR CLEANOUT ; DEBUG

 INY
 BNE :L
 INC PTR+1
 DEX
 BNE :L
:LAST
 LDX GETSIZE
:L2 LDA WDATA
 STA (PTR),Y

 JSR CLEANOUT ; DEBUG

 INY
 DEX
 BNE :L2

 LDA #$8D
 JSR COUT ; DEBUG

 JMP UPDATERXRD
*
* WRAPAROUND
*
RXWRAP
*
* CALCULATE HOW MANY BYTES UNTIL THE END OF THE BUFFER
*
 SEC
 LDA #<RXMASK
 SBC GETOFFSET
 STA ]UPPERSIZE
 LDA #>RXMASK
 SBC GETOFFSET+1
 STA ]UPPERSIZE+1
 INC ]UPPERSIZE
 BNE :NEXT
 INC ]UPPERSIZE+1
*
* SET BUFFER ADDRESS ON W5100
*
:NEXT
 LDA GETSTARTADR+1
 STA WADRH
 LDA GETSTARTADR
 STA WADRL
*
* BEGIN COPY UP TO END OF BUFFER
*
 LDA ]UPPERSIZE+1
 PHA
 LDX ]UPPERSIZE
 LDY #0
:L LDA WDATA
 STA (PTR),Y

 JSR CLEANOUT ; DEBUG

 INY
 BNE :L2
 INC PTR+1
:L2 DEX
 BNE :L
 DEC ]UPPERSIZE+1
 BNE :L
 PLA
 STA ]UPPERSIZE+1
*
* WE HAVE NOW COPIED TO THE END OF THE BUFFER, BUT THERE IS
* STILL MORE DATA REMAINING. ADJUST THE POINTERS.
*
 CLC
 LDA PTR
 ADC ]UPPERSIZE
 STA PTR
 LDA PTR+1
 ADC ]UPPERSIZE+1
 STA PTR+1
*
* MOVE THE W5100 POINTER TO THE START OF THE BUFFER
*
 LDA #>RXBASE
 STA WADRH
 LDA #<RXBASE
 STA WADRL
*
* NOW COMPUTE HOW MUCH MORE DATA IS LEFT TO COPY
* WE REUSE ]UPPERSIZE TO STORE THE DIFFERENCE
 SEC
 LDA GETSIZE
 SBC ]UPPERSIZE
 STA ]UPPERSIZE
 LDA GETSIZE+1
 SBC ]UPPERSIZE+1
 STA ]UPPERSIZE+1
*
* NOW COPY THE SECOND HALF OF THE DATA FROM THE BUFFER
*
 LDX ]UPPERSIZE
 LDY #0
:L3 LDA WDATA
 STA (PTR),Y

 JSR CLEANOUT ; DEBUG

 INY
 BNE :L4
 INC PTR+1
:L4 DEX
 BNE :L3
 DEC ]UPPERSIZE+1
 BNE :L3
 JMP UPDATERXRD
*
]UPPERSIZE DS 2
*
*
* UPDATE RXRD TO REFLECT DATA WE JUST READ
*
UPDATERXRD
 CLC
 LDA #>S0RXRD ; NEED HIGH BYTE HERE
 STA WADRH
 LDA #<S0RXRD
 STA WADRL
 LDA WDATA ; HIGH BYTE
 TAY  ; SAVE
 LDA WDATA ; LOW BYTE
 ADC GETSIZE ; ADD LOW BYTE OF RECEIVED SIZE
 TAX  ; SAVE
 TYA  ; GET HIGH BYTE BACK
 ADC GETSIZE+1 ; ADD HIGH BYTE OF RECEIVED SIZE
 TAY  ; SAVE
 LDA #<S0RXRD
 STA WADRL
 STY WDATA ; SEND HIGH BYTE
 STX WDATA ; SEND LOW BYTE
*
* SEND THE RECV COMMAND
*
 LDA #<S0CR
 STA WADRL
 LDA #SCRECV
 STA WDATA
*
*
*
 JMP CHECKRECV
*
*
* CLOSE TCP CONNECTION
*
CLOSECONN
 LDA #>S0CR ; HIGH BYTE NEEDED
 STA WADRH
 LDA #<S0CR
 STA WADRL
 LDA #SCDISCON ; DISCONNECT
 STA WDATA ; SEND COMMAND
*
* CHECK FOR CLOSED STATUS
*
CHECKCLOSED
 LDA #<S0SR
 STA WADRL
 LDA WDATA
 BNE CHECKCLOSED ; NOT CLOSED YET
 RTS  ; SOCKET IS CLOSED
*
*
* SUPPORT SUBROUTINE: CLEANOUT
* THIS "CLEANS UP" OUTPUT FOR THE APPLE BY
* SETTING THE HIGH BIT AND DOING SOME SUBSTITUTIONS
CLEANOUT
 ORA #%10000000 ; SET HIGH-BIT
 CMP #$8A ; NEWLINE?
 BNE :OUT
 LDA #$8D ; CONVERT TO CARRIAGE RETURN
:OUT
 JMP COUT
